/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

final class VersionedStorageEngine
implements IStorageEngine {
    private final int minimalVersion;
    private final List<IStorageHandler> handlers;
    private final int currentVersion;
    private final IStorageHandler saveHandler;

    VersionedStorageEngine(LinkedList<IStorageHandler> handlers) {
        this(0, handlers);
    }

    VersionedStorageEngine(int minimalVersion, LinkedList<IStorageHandler> handlers) {
        Validate.notEmpty(handlers);
        this.minimalVersion = minimalVersion;
        this.handlers = Collections.unmodifiableList(handlers);
        this.saveHandler = handlers.getLast();
        this.currentVersion = minimalVersion + handlers.size() - 1;
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 compoundTag = new class_2487();
        this.serializeNBTInto(compoundTag);
        return compoundTag;
    }

    @Override
    public void serializeNBTInto(class_2487 tag) {
        tag.method_10569("version", this.currentVersion);
        tag.method_10566("data", this.saveHandler.serializeNBT());
    }

    @Override
    public void deserializeNBT(@NotNull class_2487 nbt) {
        if (!nbt.method_10545("version")) {
            throw new IllegalArgumentException("The given NBT did not contain a versioned storage data entry. Missing the version!");
        }
        int version = nbt.method_10550("version");
        if (version < this.minimalVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the minimal version is " + this.minimalVersion);
        }
        if (version > this.currentVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the current version is " + this.currentVersion);
        }
        int index = version - this.minimalVersion;
        IStorageHandler handler = this.handlers.get(index);
        handler.deserializeNBT(nbt.method_10562("data"));
    }

    @Override
    public void serializeInto(@NotNull class_2540 packetBuffer) {
        packetBuffer.method_10794(this.serializeNBT());
    }

    @Override
    public void deserializeFrom(@NotNull class_2540 packetBuffer) {
        this.deserializeNBT(packetBuffer.method_30617());
    }

    public Collection<IStorageHandler> getHandlers() {
        return this.handlers;
    }
}

